/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10;

import djbuch.kapitel_06.GC;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.NotesException;

/**
 * @author Thomas Ekert
 *
 */
public class DJLoopExecutor {

	private final DJLoopCommand command;
	private static final String EXCEPTION_NOTYPE = "Command hat falschen Typ.";
	private static final int EXCEPTION_NO = 999;
	
	public DJLoopExecutor (DJLoopCommand command) {
		this.command=command;
	}
	
	public void doLoop() throws NotesException {
		switch (command.getType()) {
		case DJLoopCommand.TYPE_VIEW: {
			doLoopView();
			break;
		}
		case DJLoopCommand.TYPE_COLLECTION:
		case DJLoopCommand.TYPE_DATABASE: {
			doLoopCollection();
			break;	
		}
		default:
			throw new NotesException(EXCEPTION_NO, EXCEPTION_NOTYPE);
		}
	}
	
	private void doLoopView () throws NotesException {
		Document doc = null;
		Document nextDoc = null;
		try {
			doc = command.getView().getFirstDocument();
			while (doc != null) {
				if (!command.execute(doc)) {
					break;
				}
				nextDoc=command.getView().getNextDocument(doc);
				GC.recycle(doc);
				doc=nextDoc;
			}
		} finally {
			GC.recycle(doc);
			GC.recycle(nextDoc);
		}
	}
	
	private void doLoopCollection() throws NotesException {
		Document doc = null;
		Document nextDoc = null;
		DocumentCollection dc = null;
		try {
			dc = (command.getType() == DJLoopCommand.TYPE_DATABASE) ? command
					.getDatabase().getAllDocuments() : command.getCollection();
			if (dc==null) {
				return;
			}
			doc = dc.getFirstDocument();
			while (doc != null) {
				if (!command.execute(doc)) {
					break;
				}
				nextDoc=dc.getNextDocument();
				GC.recycle(doc);
				doc=nextDoc;
			}
		} finally {
			GC.recycle(doc);
			GC.recycle(nextDoc);
			if (command.getType() == DJLoopCommand.TYPE_DATABASE) {
				//Sonderfall. Die DocumentCollection wurde explizit erzeugt.
				dc.recycle();
			}
		}
	}
}
